% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal-viridis.R
\name{pal_viridis}
\alias{pal_viridis}
\alias{viridis_pal}
\title{Viridis palette}
\usage{
pal_viridis(alpha = 1, begin = 0, end = 1, direction = 1, option = "D")

viridis_pal(alpha = 1, begin = 0, end = 1, direction = 1, option = "D")
}
\arguments{
\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin, end}{The (corrected) hue in \verb{[0,1]} at which the color map
begins and ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{option}{A character string indicating the color map option to use.
Eight options are available:
\itemize{
\item \code{"magma"} (or \code{"A"})
\item \code{"inferno"} (or \code{"B"})
\item \code{"plasma"} (or \code{"C"})
\item \code{"viridis"} (or \code{"D"})
\item \code{"cividis"} (or \code{"E"})
\item \code{"rocket"} (or \code{"F"})
\item \code{"mako"} (or \code{"G"})
\item \code{"turbo"} (or \code{"H"})
}}
}
\description{
Viridis palette
}
\examples{
show_col(pal_viridis()(10))
show_col(pal_viridis(direction = -1)(6))
show_col(pal_viridis(begin = 0.2, end = 0.8)(4))
show_col(pal_viridis(option = "plasma")(6))
}
\references{
\url{https://bids.github.io/colormap/}
}
