% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsformula.R
\name{update_adterms}
\alias{update_adterms}
\title{Update Formula Addition Terms}
\usage{
update_adterms(formula, adform, action = c("update", "replace"))
}
\arguments{
\item{formula}{Two-sided formula to be updated.}

\item{adform}{One-sided formula containing addition terms to update
\code{formula} with.}

\item{action}{Indicates what should happen to the existing addition terms in
\code{formula}. If \code{"update"} (the default), old addition terms that
have no corresponding term in \code{adform} will be kept. If
\code{"replace"}, all old addition terms will be removed.}
}
\value{
An object of class \code{formula}.
}
\description{
Update additions terms used in formulas of \pkg{brms}. See
\code{\link{addition-terms}} for details.
}
\examples{
form <- y | trials(size) ~ x
update_adterms(form, ~ trials(10))
update_adterms(form, ~ weights(w))
update_adterms(form, ~ weights(w), action = "replace")
update_adterms(y ~ x, ~ trials(10))

}
