/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_HRV_STATUS_SUMMARY_MESG_HPP)
#define FIT_HRV_STATUS_SUMMARY_MESG_HPP

#include "fit_mesg.hpp"

namespace fit
{

class HrvStatusSummaryMesg : public Mesg
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 Timestamp = 253;
       static const FIT_UINT8 WeeklyAverage = 0;
       static const FIT_UINT8 LastNightAverage = 1;
       static const FIT_UINT8 LastNight5MinHigh = 2;
       static const FIT_UINT8 BaselineLowUpper = 3;
       static const FIT_UINT8 BaselineBalancedLower = 4;
       static const FIT_UINT8 BaselineBalancedUpper = 5;
       static const FIT_UINT8 Status = 6;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    HrvStatusSummaryMesg(void) : Mesg(Profile::MESG_HRV_STATUS_SUMMARY)
    {
    }

    HrvStatusSummaryMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of timestamp field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimestampValid() const
    {
        const Field* field = GetField(253);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns timestamp field
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetTimestamp(void) const
    {
        return GetFieldUINT32Value(253, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set timestamp field
    ///////////////////////////////////////////////////////////////////////
    void SetTimestamp(FIT_DATE_TIME timestamp)
    {
        SetFieldUINT32Value(253, timestamp, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of weekly_average field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsWeeklyAverageValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns weekly_average field
    // Units: ms
    // Comment: 7 day RMSSD average over sleep
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetWeeklyAverage(void) const
    {
        return GetFieldFLOAT32Value(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set weekly_average field
    // Units: ms
    // Comment: 7 day RMSSD average over sleep
    ///////////////////////////////////////////////////////////////////////
    void SetWeeklyAverage(FIT_FLOAT32 weeklyAverage)
    {
        SetFieldFLOAT32Value(0, weeklyAverage, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of last_night_average field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLastNightAverageValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns last_night_average field
    // Units: ms
    // Comment: Last night RMSSD average over sleep
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLastNightAverage(void) const
    {
        return GetFieldFLOAT32Value(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set last_night_average field
    // Units: ms
    // Comment: Last night RMSSD average over sleep
    ///////////////////////////////////////////////////////////////////////
    void SetLastNightAverage(FIT_FLOAT32 lastNightAverage)
    {
        SetFieldFLOAT32Value(1, lastNightAverage, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of last_night_5_min_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLastNight5MinHighValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns last_night_5_min_high field
    // Units: ms
    // Comment: 5 minute high RMSSD value over sleep
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLastNight5MinHigh(void) const
    {
        return GetFieldFLOAT32Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set last_night_5_min_high field
    // Units: ms
    // Comment: 5 minute high RMSSD value over sleep
    ///////////////////////////////////////////////////////////////////////
    void SetLastNight5MinHigh(FIT_FLOAT32 lastNight5MinHigh)
    {
        SetFieldFLOAT32Value(2, lastNight5MinHigh, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of baseline_low_upper field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBaselineLowUpperValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns baseline_low_upper field
    // Units: ms
    // Comment: 3 week baseline, upper boundary of low HRV status
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetBaselineLowUpper(void) const
    {
        return GetFieldFLOAT32Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set baseline_low_upper field
    // Units: ms
    // Comment: 3 week baseline, upper boundary of low HRV status
    ///////////////////////////////////////////////////////////////////////
    void SetBaselineLowUpper(FIT_FLOAT32 baselineLowUpper)
    {
        SetFieldFLOAT32Value(3, baselineLowUpper, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of baseline_balanced_lower field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBaselineBalancedLowerValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns baseline_balanced_lower field
    // Units: ms
    // Comment: 3 week baseline, lower boundary of balanced HRV status
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetBaselineBalancedLower(void) const
    {
        return GetFieldFLOAT32Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set baseline_balanced_lower field
    // Units: ms
    // Comment: 3 week baseline, lower boundary of balanced HRV status
    ///////////////////////////////////////////////////////////////////////
    void SetBaselineBalancedLower(FIT_FLOAT32 baselineBalancedLower)
    {
        SetFieldFLOAT32Value(4, baselineBalancedLower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of baseline_balanced_upper field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBaselineBalancedUpperValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns baseline_balanced_upper field
    // Units: ms
    // Comment: 3 week baseline, upper boundary of balanced HRV status
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetBaselineBalancedUpper(void) const
    {
        return GetFieldFLOAT32Value(5, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set baseline_balanced_upper field
    // Units: ms
    // Comment: 3 week baseline, upper boundary of balanced HRV status
    ///////////////////////////////////////////////////////////////////////
    void SetBaselineBalancedUpper(FIT_FLOAT32 baselineBalancedUpper)
    {
        SetFieldFLOAT32Value(5, baselineBalancedUpper, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of status field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStatusValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns status field
    ///////////////////////////////////////////////////////////////////////
    FIT_HRV_STATUS GetStatus(void) const
    {
        return GetFieldENUMValue(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set status field
    ///////////////////////////////////////////////////////////////////////
    void SetStatus(FIT_HRV_STATUS status)
    {
        SetFieldENUMValue(6, status, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_HRV_STATUS_SUMMARY_MESG_HPP)
