# Comment améliorer les pages `start.html` ?

Les pages `start.html`,
qui accueillent le visiteur quand il entre dans une section ou une sous-section,
sont par défaut générées automatiquement par Sphinx,
avec une simple liste des sous-sections et des pages qui se trouvent à la racine de la section courante.
Il est souvent souhaitable de modifier cette page à la main
pour expliquer quel est l'objet de la section et de ses sous-sections
et pour exposer la matière dans un ordre plus logique.

Vous en trouverez un exemple simple [ici](https://faq.gutenberg-asso.fr/3_composition/start.html).

Ces pages se divisent en deux parties :

  * Un bloc de code `toctree` utilisé par Sphinx pour générer la table des matières *dans le panneau latéral* ;
  * Le texte qui sera lu par les visiteurs de la FAQ.

:::{important}
Pour que la version PDF de la FAQ présente le texte introductif avant le
contenu des sous-sections, il est impératif que la directive `toctree` soit
laissée au bas du fichier source Markdown, après ce texte introductif.  La
sortie HTML est, quant à elle, indifférente au positionnement relatif de cette
directive.
:::


## Bloc `toctree`

```{attention}
Il ne faut pas supprimer complètement ce(s) bloc(s) :
les pages concernées seraient ignorées dans le panneau de navigation latéral !
```

Les pages `start` générées automatiquement par Sphinx
contiennent, selon les cas, un ou deux blocs de code `toctree`.
Voici la version avec deux blocs :

~~~text
<div class="directory-list">

```{toctree}
:glob: true
:maxdepth: 1

*/start
```

</div>

<div class="question-list">

```{toctree}
:glob: true
:maxdepth: 1

*
```

</div>
~~~

Dans tous les cas, il faut les remplacer par l'unique bloc suivant,
où l'on ajoute l'attribut `:hidden:`
et où l'on supprime les balises `<div>` qui entourent les blocs de code :

~~~text
```{toctree}
:glob: true
:maxdepth: 1
:hidden:

*/start
*
```
~~~

Ce bloc permet d'afficher dans le panneau latéral d'abord les sous-sections,
puis les pages rangées à la racine de la section courante.

## Texte lu par le visiteur

Il suffit de rédiger la page comme n'importe quelle autre page de la FAQ,
en prenant soin d'inclure des liens vers toutes les pages et sous-sections de la (sous-)section courante.

```{attention}
Vérifier que l'on a bien inclus des liens vers toutes les pages et sous-sections !
```

## Et si quelqu'un ajoute ou supprime des pages plus tard dans cette section ?

Quand on ajoute ou supprime des pages,
le mieux est de vérifier si la page `start` de la section parente a été modifiée manuellement,
et dans ce cas, opérer les changements nécessaires.
En cas d'oubli, un script est lancé régulièrement pour vérifier que les liens soient à jour.

On trouvera la liste des pages `start` qui requièrent une intervention :

  * Sur la page [](/8_contribuer/corrections/questions_a_reviser),
    sous réserve qu'elle ait été actualisée récemment ;
  * Sur le dépôt Git de la FAQ, dans les fichiers
    `nouveaux_liens_manquants` et `nouveaux_liens_obsoletes`.
    Comme ils sont générés par le script de vérification, ils sont toujours à jour
    (à ceci près qu'ils n'indiquent pas quelles pages ont été corrigées).

## Et si je veux conserver le sommaire automatique ?

Dans certains cas, il est souhaitable de conserver le sommaire automatique
tout en ajoutant une petite introduction et, éventuellement, les sources utilisées dans la section.
Il suffit de conserver les bloc `toctree` générés par Sphinx
et d'ajouter votre texte avant et après ces blocs.
En voici un exemple : [](/2_programmation/erreurs/start).
