---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, références
---

# Comment faire référence à une entrée bibliographique ?

Cela se fait avec la commande `\cite[⟨précision⟩]{⟨clé⟩}`. Cette commande 
prend un argument obligatoire, la `⟨clé⟩`, qui permet d'indiquer 
quelle est la référence bibliographique associée. La commande accepter 
aussi un argument optionnel, une `⟨précision⟩` qui permet d'indiquer, 
par exemple, à quelle partie du document il est fait référence.

Voici un exemple d'utilisation de `\cite` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Pour plus de renseignements sur la bibliographie,
consulter~\cite[chapitre 13]{Companion}.

\begin{thebibliography}{MMM99}
\bibitem[GMS94]{Companion}
  M. Goossens, F. Mittelbach et A. Samarin,
  \textit{The \LaTeX{} Companion},
  Addison-Wesley, 1994.
\end{thebibliography}
\end{document}
```

Le format de cet exemple ne tire par partie de fonctionnalités avancées
de gestion des bibliographiques. Consultez la question 
"[](/3_composition/annexes/bibliographie/construire_une_bibliographie)"
pour en savoir plus.