---
myst:
  html_meta:
    keywords: LaTeX, extensions obsolètes, packages obsolètes, extensions historiques, packages historiques
---
# Que faisaient ces extensions introuvables ?

Si une très large majorité d'extensions sont disponibles sur le site du [CTAN](../documentation/le_catalogue_du_ctan.md), certaines ont connu des diffusions moins classiques. Dans ce dernier cas, elles sont beaucoup plus susceptibles de disparaître, laissant alors certains utilisateurs désarmés devant un code LaTeX exigeant telle ou telle extension introuvable.

À l'évidence, ces extensions ne sont pas recommandées et sont également généralement devenues obsolètes. Cette page liste et donne quelques informations sur ces extensions. Dans certains cas, le code de l'extension est mis à disposition.

Avant de parcourir cette page, pensez à rechercher votre extension avec la [recherche avancée](https://ctan.org/search?phrase=&ext=true&_PKG=&PKG=on&_AUTHORS=&AUTHORS=on&_TOPICS=&TOPICS=on&_FILES=&FILES=on&_PORTAL=&PORTAL=on&wildcard=on&max=16) du CTAN. Elle permet en particulier de rechercher un fichier par son nom, ce qui peut donner des résultats intéressants. Par exemple, l'extension `catmac` (une extension pour LaTeX 2.09) ne se trouve qu'avec cette recherche avancée.

Dans la mesure du possible, un renvoi vers la page des [extensions obsolètes](liste_des_packages_obsoletes.md) vous permettra également de trouver des extensions recommandées pour obtenir des fonctionnalités similaires.

## L'extension `atxy`

Cette extension, écrite par Colin Hogben à partir de 1991, permettait de positionner du texte à une position fixée par rapport au bord gauche et au bord haut de la page courante. Elle avait un défaut : si le document ne contenait que des commandes `atxy`, il n'y avait pas de document `dvi` généré. Pour corriger ce point, il fallait ajouter n'importe quoi au début du document, un [strut](wp:Strut_(typesetting)) par exemple (avec `\strut`), pour que le document soit produit.

Une copie de cette extension `atxy` (version 1.1) est mise à disposition [ici](/_static/old_extensions/atxy.sty).

La page des [extensions obsolètes](liste_des_packages_obsoletes.md) propose une extension donnant des fonctionnalités similaires.

```{todo}
Traiter de la même manière les extensions suivantes.
```

## L'extension `eclbkbox`

Cette extension a été créée par Hideki Isozaki en 1992. Elle permettait d'encadrer du texte avec l'environnement `breakbox`. Deux commandes, `\bkcounttrue` et `\bkcountfalse`, permettaient d'afficher ou de supprimer la numérotation des lignes de texte de la boîte (à l'extérieur de celle-ci). 

Elle est à l'origine de l'extension <ctanpkg:boites>, de Vincent Zoonekynd, qui en a étendu le code et qui l'a documenté.

Une copie de cette extension `eclbkbox` est mise à disposition [ici](/_static/old_extensions/eclbkbox.sty).

## L'extension `floatfig`

L'extension <ctanpkg:floatfig>, écrit initialement pour LaTeX 2.09, fonctionne bien dans des cas simples. Elle définit la commande `floatingfigure`, qui ne fonctionne cependant pas en mode multicolonnes. Voici un exemple :

```{noedit}
\documentclass[french]{report}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{boxedminipage}
\usepackage{floatfig}
\usepackage{babel}
\begin{document}
\initfloatingfigs
Il faut commencer le document par la commande \verb+\initfloatingfigs+, afin
d'initialiser l'extension. La documentation indique que ce n'est pas
indispensable, mais l'extension arrête la compilation si ce n'est pas fait.

\medskip
\begin{floatingfigure}{6cm}
  Ceci est une « figure » de 6~centimètres de large. La hauteur sera calculée
  par \LaTeX{} pour que le texte environnant entoure correctement cette
  figure. Bien sûr, dans un environnement \verb|figure|, rien n'empêche
  de ne mettre que du texte...
\end{floatingfigure}

La figure sera toujours placée à droite sur une page de droite, et à gauche sur
une page de gauche.  Noter, comme le prouve cet exemple, que l'environnement
\verb|floatingfigure| entraîne automatiquement un saut de paragraphe. Il
faut donc placer la figure au début du paragraphe où on veut la placer. Noter
également (ça ne se voit pas dans cet exemple, mais c'est vrai) qu'il n'y a pas,
dans ce package, d'environnement \verb|floatingtable|. La légende, en
particulier, est toujours appelée « \figurename ».
\end{document}
```

## D'autres éléments introuvables

### Le programme `wflman`

Probablement dû à W. F. Lupton, il servirait à faire des conversions (C/C++ vers
LaTeX) ou à générer des docs LaTeX, RTF, man et HTML (au choix).
