# FraGoLi v. 1.2.3 \y 2025
> Collection of LaTeX commands used by the institute of linguistics - Goethe University Frankfurt

The package is mainly designed to provide a minimal and user-friendly syntax for constructing large and complex semantic derivations. 
Formula-Style is losely based on the accompanying material to an introductory course to linguistic semantics by Thomas Ede Zimmermann.

## Description

The primary goal of this package is to provide short and easy to read macros for large and complex semantic derivations, following the specific notational style used at Goethe University Frankfurt. It includes a comprehensive set of commands for text formatting and various types of bracketing, ensuring a consistent style—particularly when distinguishing between meta-language and object-language within a single derivation or formula.

### Dependencies

* {LaTeX2e}[1994/06/01]
* {xparse, xcolor, stmaryrd, enumitem, nicefrac, bm, amsmath, amssymb, xstring, expl3, pdftexcmds, etoolbox, kvoptions, comment, varwidth, ulem}

## Authors

ex. Paul Eduard Koenig 

## Version History

* 1.2.3
	* Fix wrong argument ordering in indirect translation commands
* 1.2.2
	* Add degree semantics support.
	* Add traces with spaces.
	* Add new commands for semantic lexicon entries.
	* Add typenestingstyle (credits to \textit{C\'{e}cile Meier})
	* Add new pre defined lambda heads.
	* Add commands to change package settings mid document.
	* Add basic brackets command for \textit{cps} prevention and bold mode.
	* Add type shortcuts for fgls env.
	* Add formatting options for types, situations and direct/indirect superscripts.
	* Add lambda headers with quantifiers for fgls env.
	* Fix fglsem command with regard to line breaks. Adding varwidth dependency for that.
	* Fix some pre-defined lambda heads not beeing bold in bold mode.
	* Fix spacing on lambda heads with visible types in upper mode
	* Fix spacing on derivation steps
* 1.1.1
    * Fix missing package dependency.
    * Fix text overline overriding uuline internal length.
    * Fix parentheses on lambda quantifier heads being bold in non bold mode.
    * Add lambdaheadstyle package option.
    * Add new fuction framework.
    * Add new logic commands.
    * Add new logic constants.
    * Add new relation constants.
    * Add new quantifier commands.
    * Extend set command.
* 1.0.0
    * Initial Release

## License

This program can be redistributed and/or modified under the terms
of the LaTeX Project Public License Distributed from CTAN archives
in directory macros/latex/base/lppl.txt.