# 2024-06-11 Triage Log

This week saw more regressions than wins, caused mostly by code being reorganized within the
compiler and a new feature being implemented. There have also been some nice improvements caused
by better optimizing spans.

Triage done by **@kobzol**.
Revision range: [1d52972d..b5b13568](https://perf.rust-lang.org/?start=1d52972dd8592edf4026aa577c8ce69acc0ac2d1&end=b5b13568fb5da4ac988bde370008d6134d3dfe6c&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 2.7%]   | 105   |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.1%, 6.9%]   | 74    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.0%, -0.2%] | 20    |
| Improvements ✅ <br /> (secondary) | -1.4% | [-8.8%, -0.2%] | 32    |
| All ❌✅ (primary)                 | 0.5%  | [-1.0%, 2.7%]  | 125   |


5 Regressions, 3 Improvements, 4 Mixed; 5 of them in rollups
59 artifact comparisons made in total

#### Regressions

Rollup of 8 pull requests [#125976](https://github.com/rust-lang/rust/pull/125976) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bc33782c23bc3e04eab7c85c43bbe1a108b11f80&end=30ea1a2693bb1ba4b119ac6257985b9e11e45b83&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9% | [0.2%, 1.3%] | 14    |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.4%, 2.8%] | 5     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.9% | [0.2%, 1.3%] | 14    |

* Looks like it was caused by [#125968](https://github.com/rust-lang/rust/pull/125968).
* This PR resulted in some code being shuffled around the compiler (what we call "codegen noise"),
we determined that it is not worth investigating further.

Don't walk the bodies of free constants for reachability. [#122505](https://github.com/rust-lang/rust/pull/122505) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=72fdf913c53dd0e75313ba83e4aa80df3f6e2871&end=d0ccb5413ee2d9d40b574ad7998ffa866811d3f8&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.8% | [0.2%, 2.6%] | 4     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.8% | [0.2%, 2.6%] | 4     |

* The compiler needs to do a little bit more work after this PR, so the regression is expected.

Unsafe extern blocks [#124482](https://github.com/rust-lang/rust/pull/124482) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2b6a34273d820df4140a00984d38d40c745fb565&end=2d28b6384e5e0a2c9d1500a1f65e35423453fbf6&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 32    |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.2%, 0.3%] | 4     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 32    |

* This PR adds a new feature, so a small performance regression is expected.

Rollup of 7 pull requests [#126108](https://github.com/rust-lang/rust/pull/126108) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b74702fbb2a2bd56b39849d66bd59a453ed8c89e&end=468310ea0cdec87460b83710a3a78825bcae73c5&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.3%] | 5     |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.5%, 1.5%] | 15    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.3%] | 5     |

* Caused by [#125724](https://github.com/rust-lang/rust/pull/125724), which moves some code to
a different compiler package, so that it can be used with the new trait solver.

Add Rust for Linux `auto` CI job [#125209](https://github.com/rust-lang/rust/pull/125209) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a3167859f2fd8ff2241295469876a2b687280bdc&end=d402830c8a356332de93761d6996faf5a2ca29ca&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 4.3% | [2.5%, 6.1%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

* This PR did not modify the compiler at all, so this has to be noise.

#### Improvements

Rollup of 11 pull requests [#125989](https://github.com/rust-lang/rust/pull/125989) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=23e040adec50e10d3ff8103e405ff79e44908e70&end=a330e49593ee890f9197727a3a558b6e6b37f843&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [2.0%, 2.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -     | -              | 0     |


Revert: create const block bodies in typeck via query feeding [#125918](https://github.com/rust-lang/rust/pull/125918) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=468310ea0cdec87460b83710a3a78825bcae73c5&end=1be24d70ced0d6b8d41a48b6a28b3790f6facf4c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 35    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.3%] | 9     |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 35    |


Rollup of 9 pull requests [#126240](https://github.com/rust-lang/rust/pull/126240) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d402830c8a356332de93761d6996faf5a2ca29ca&end=b5b13568fb5da4ac988bde370008d6134d3dfe6c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.3% | [-6.4%, -0.2%] | 3     |
| All ❌✅ (primary)                 | -     | -              | 0     |


#### Mixed

Make TLS accessors closures that return pointers [#125525](https://github.com/rust-lang/rust/pull/125525) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=90d6255d82dcfd0b73dbaa4f172a7f9886dcc2c1&end=27529d5c2526eab5aa03d765426c44ea55c5d269&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 2.9%  | [2.9%, 2.9%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.1%, -0.3%] | 14    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-1.1%, 0.4%]  | 20    |

* More wins than losses.

Rollup of 11 pull requests [#126134](https://github.com/rust-lang/rust/pull/126134) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4dc24ae394a03755cf337bebc8cd2e022a1a4848&end=804421dff5542c9c7da5c60257b5dbc849719505&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.0%]   | 43    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.8%]   | 14    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 3     |
| All ❌✅ (primary)                 | 0.4%  | [0.2%, 1.0%]   | 43    |


rustc_span: Optimize syntax context updates in spans [#125017](https://github.com/rust-lang/rust/pull/125017) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0de24a5177b1d49d6304f76f3ab159faaec134f9&end=a3167859f2fd8ff2241295469876a2b687280bdc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.6%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.4%, 1.0%]   | 10    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.5%, -0.2%] | 37    |
| Improvements ✅ <br /> (secondary) | -1.5% | [-9.3%, -0.2%] | 33    |
| All ❌✅ (primary)                 | -0.3% | [-1.5%, 0.6%]  | 43    |

* More improvements than regressions. 

Add `SingleUseConsts` mir-opt pass [#125910](https://github.com/rust-lang/rust/pull/125910) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b5b13568fb5da4ac988bde370008d6134d3dfe6c&end=fa1681c9f6a66f0240c46c98bfef6209c9d6df23&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -2.3% | [-2.9%, -1.7%] | 2     |
| All ❌✅ (primary)                 | -0.1% | [-0.4%, 0.4%]  | 6     |

* Slighty more wins than losses on instructions.
* Small binary size win.
