% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_time.R
\name{PiecewiseSurvivalTime}
\alias{PiecewiseSurvivalTime}
\title{Piecewise Exponential Survival Time}
\description{
Class for the definition of piecewise survival times.
}
\details{
\code{PiecewiseSurvivalTime} is a class for the definition of piecewise survival times.
}
\section{Fields}{

\describe{
\item{\code{piecewiseSurvivalTime}}{The time intervals for the piecewise definition of the exponential survival time cumulative distribution function. Is a numeric vector.}

\item{\code{lambda1}}{The assumed hazard rate in the treatment group. Is a numeric vector of length \code{kMax}.}

\item{\code{lambda2}}{The assumed hazard rate in the reference group. Is a numeric vector of length 1.}

\item{\code{hazardRatio}}{The hazard ratios under consideration. Is a numeric vector of length \code{kMax}.}

\item{\code{pi1}}{The assumed event rate in the treatment group. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{pi2}}{The assumed event rate in the control group. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{median1}}{The assumed median survival time in the treatment group. Is a numeric vector.}

\item{\code{median2}}{The assumed median survival time in the reference group. Is a numeric vector of length 1.}

\item{\code{eventTime}}{The assumed time under which the event rates are calculated. Is a numeric vector of length 1.}

\item{\code{kappa}}{The shape of the Weibull distribution if \code{kappa!=1}. Is a numeric vector of length 1.}

\item{\code{piecewiseSurvivalEnabled}}{Indicates whether specification of piecewise definition of survival time is selected. Is a logical vector of length 1.}

\item{\code{delayedResponseAllowed}}{If \code{TRUE}, delayed response is allowed, if \code{FALSE} the response is not delayed.}

\item{\code{delayedResponseEnabled}}{If \code{TRUE}, delayed response is enabled, if \code{FALSE} delayed response is not enabled.}
}}

\keyword{internal}
