/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager == null ? (class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager = EasyX509TrustManager.class$("org.apache.commons.httpclient.contrib.ssl.EasyX509TrustManager")) : class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager);
    static /* synthetic */ Class class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager;

    public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        System.out.println("got " + trustmanagers.length + " trust managers");
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public boolean isClientTrusted(X509Certificate[] certificates) {
        boolean val = false;
        try {
            this.standardTrustManager.checkClientTrusted(certificates, "RSA");
            val = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    public boolean isServerTrusted(X509Certificate[] certificates) {
        if (certificates != null) {
            LOG.debug("Server certificate chain:");
            System.out.println("Server certificate chain:");
            for (int i = 0; i < certificates.length; ++i) {
                LOG.debug("X509Certificate[" + i + "]=" + certificates[i]);
                System.out.println("X509Certificate[" + i + "]=" + certificates[i]);
            }
        }
        if (certificates != null && certificates.length == 1) {
            X509Certificate certificate = certificates[0];
            try {
                certificate.checkValidity();
            }
            catch (CertificateException e) {
                LOG.error(e.toString());
                return false;
            }
            return true;
        }
        System.out.println("Using standard trust manager");
        boolean val = false;
        try {
            X509Certificate[] certs2 = new X509Certificate[]{certificates[0], certificates[1]};
            this.standardTrustManager.checkServerTrusted(certs2, "RSA");
            val = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (authType.equalsIgnoreCase("RSA")) {
            this.isServerTrusted(certificates);
        } else {
            X509Certificate[] certs2 = new X509Certificate[]{certificates[0], certificates[1]};
            this.standardTrustManager.checkServerTrusted(certs2, authType);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

