// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Test that Unicode property escapes for `RGI_Emoji` (property of strings)
  match Emoji 16.0 strings.
info: |
  Generated by https://github.com/mathiasbynens/caniunicode
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes, regexp-v-flag]
includes: [regExpUtils.js]
---*/

testPropertyOfStrings({
  regExp: /^\p{RGI_Emoji}+$/v,
  expression: "\\p{RGI_Emoji}",
  matchStrings: [
    "\u{1F1E8}\u{1F1F6}",
    "\u{1FA89}",
    "\u{1FA8F}",
    "\u{1FABE}",
    "\u{1FAC6}",
    "\u{1FADC}",
    "\u{1FADF}",
    "\u{1FAE9}"
  ],
});

reportCompare(0, 0);
