#include "rrconflict.ih"

void RRConflict::compareReductions(size_t *rrNr, size_t second)
{
    second = d_reducible[second];

    RRData rrData(
        d_firstLA->intersection(
            d_itemVector[second].lookaheadSet()
        )
    );

    if (rrData.empty())                 // no overlap
        return;

    StateItem const &firstItem = d_itemVector[d_firstIdx];
    StateItem const &secondItem = d_itemVector[second];

    switch ( Terminal::comparePrecedence(
                firstItem.precedence(), secondItem.precedence()
             )
    )
    {
        case Terminal::EQUAL:
            rrData.setIdx(
                firstItem.nr() < secondItem.nr() ? 
                    RRData::KEEP_FIRST 
                : 
                    RRData::KEEP_SECOND,
                d_firstIdx, second
            );

            if (size_t firstNr = firstItem.nr(); firstNr != *rrNr)
            {                       // found a new RR conflict for firstItem:
                *rrNr = firstNr;    // store its nr, and inc. s_nConflicts
                ++s_nConflicts;
            }

        break;

        case Terminal::SMALLER:             // first precedence < second prec.
            rrData.setIdx(d_firstIdx);
        break;

        case Terminal::LARGER:              // shift precedence > prod. prec.
            rrData.setIdx(second);
        break;
    }

    d_rmReduction.push_back(rrData);
}

